/* ============ */
/* cupnprob.c	*/
/* ============ */
#include <defcodes.h>
#include <math.h>
#include <mconf.h>
#include <miscdefs.h>
/* ==================================================================== */
/* CalcCouponProbs - Computes Probabilities for Coupon Collector's Test	*/
/* ==================================================================== */
void
CalcCouponProbs(int SetSize, int MaxLength, double *CouponProbs)
{
    double  ProbCoef;
    int     r;

    ProbCoef = exp(lgam(SetSize+1) - (SetSize - 1) * log(SetSize));

    P(printf("ProbCoef = %.15e\n", ProbCoef));

    for (r = SetSize; r < MaxLength; ++r)
    {
	double	StirlNum = (double)Stirling2(r-1, SetSize-1);
	P(printf("Stirling2(%3d, %3d) = %.15Le\n", r-1, SetSize-1,
		Stirling2(r-1, SetSize-1)));

	ProbCoef /= (double)SetSize;
	*CouponProbs = ProbCoef * StirlNum;
	P(printf("Coupon Probability #%3d = %.15e\n",
	    r - SetSize + 1, *CouponProbs));
	++CouponProbs;
    }

    P(printf("Stirling2(%3d, %3d) = %.15Le\n", MaxLength-1, SetSize,
	Stirling2(MaxLength-1, SetSize)));

    *CouponProbs =
	1.0 - ProbCoef * (double)Stirling2(MaxLength-1, SetSize);
    P(printf("Coupon Probability #%3d = %.15e\n",
	    r - SetSize + 1, *CouponProbs));
}
